// Si MARINS (et toutes ses variantes)

GIWIK.init.js(['css','msg']);	
	
if (GIWIK.system_codename.match(/^MARINS/i))
{	
	HEADING.readConf.local = function ()
	{	
		switch(window[system].MesaCrt[3])
		{
			case 1 : 	//rend "disable" le bouton radio miroir
				window.Radio_ref_mesa0.enable();
				window.Radio_ref_mesa1.disable();
				break;
			case 2 : 	//rend "disable" le bouton radio pion de centrage
				window.Radio_ref_mesa0.disable();
				window.Radio_ref_mesa1.enable();
				break;
			case 3 : 	//rend "enable" les boutons radio pion de centrage et miroir
				window.Radio_ref_mesa0.enable();
				window.Radio_ref_mesa1.enable();
				break;				
			default :
				window.Radio_ref_mesa0.disable();
				window.Radio_ref_mesa1.disable();
				break;
			
		}
		
		//Si ni pion, ni miroir n'est disponible, on ne coche pas de radio bouton (à noter que ce cas de figure découle d'un problème en production)
		if(window[system].MesaCrt[3] != 0)
		{
			window.Radio_ref_mesa0.setValue(window[system].MesaCrt[4]);
			window.Radio_ref_mesa1.setValue(window[system].MesaCrt[4]);		
		}
	}

		
	HEADING.getConf.local = function ()
	{
		var _params = {};
		
		_params['MesaCrt'] = "";
		
		return _params;
	}	
	
	
	HEADING.sendConf.local = function ()
	{
		var _params = {};

		if((typeof window.Radio_ref_mesa0.getValue()) != 'undefined')
		{
			radio_value = window.Radio_ref_mesa0.getValue();	//cas particulier d'utilisation des radios bouton, renvoi l'identifiant du bouton radio coché, ce cas de figure ne fonctionne qu'avec 2 boutons radio dont les identifiant sont 0 et 1
		}
		else
		{
			radio_value = 0;
		}
		
		_params['MesaCrt'] = window.Input_MesaCrtH.getValue()+","+window.Input_MesaCrtR.getValue()+","+window.Input_MesaCrtP.getValue()
							+ ","+ window[system].MesaCrt[3]
							+ ","+ radio_value;
		return _params;
	};

	HEADING.construct.local = function ()
	{
		var cnt = ''
		cnt	+='<div class="mesa_title">'+MSG(['parameters','mesa_ref_title'])+'</div>'
			+ '<div id="usermsg_wrong_ref_mesa"></div>'
			+'<table id="tab_choix_mesa">'
				+'<tr>'
					+'<td>'
						+'<div id="radio_ref_mesa0"></div>'
					+'</td>'
					+'<td>'
						+'<div id="radio_ref_mesa1"></div>'
					+'</td>'						
				+'</tr>'
			+'</table>'		
			+'<div class="mesa_title">'+MSG(['parameters','mesa_value_title'])+'</div>'		
	
		GIWIK.write('params_finealign_ctnr',cnt,'prepend');

		$('#params_finealign_label').html(MSG(['parameters','mesa_title']));
		
		window.Radio_ref_mesa0 = new Input_radio('Radio_ref_mesa0', false);
		window.Radio_ref_mesa0.margin = '10px 0px';
		window.Radio_ref_mesa0.margin_left = HEADING.inputs_left_margin_radio;
		window.Radio_ref_mesa0.padding_label_linear = '0px 0px 0px 4px';
		window.Radio_ref_mesa0.construct('radio_ref_mesa0','choix_mesa','linear',MSG(['parameters','mesa_pin']),0,true);
		window.Radio_ref_mesa0.setAction('HEADING.updateMsg_wrong_ref_mesa();');
		window.Radio_ref_mesa0.show();
		window.Radio_ref_mesa0.enable();
		
		window.Radio_ref_mesa1 = new Input_radio('Radio_ref_mesa1', false);
		window.Radio_ref_mesa1.margin = '0px'
		window.Radio_ref_mesa1.padding_label_linear = '0 0 0 4px';
		window.Radio_ref_mesa1.margin_left = HEADING.inputs_right_margin_radio;
		window.Radio_ref_mesa1.construct('radio_ref_mesa1','choix_mesa','linear',MSG(['parameters','mesa_mirror']),1,true);
		window.Radio_ref_mesa1.setAction('HEADING.updateMsg_wrong_ref_mesa();');
		window.Radio_ref_mesa1.show();	
		window.Radio_ref_mesa1.enable();	
		
		window.Usermsg_wrong_ref_mesa = new User_msg('Usermsg_wrong_ref_mesa');
		window.Usermsg_wrong_ref_mesa.margin = '5px 0 10px 0';
		window.Usermsg_wrong_ref_mesa.construct('usermsg_wrong_ref_mesa', 3, "");
		window.Usermsg_wrong_ref_mesa.hide();
	};
	
	//Message d'avertissement pour indiquer que la référence de mésalignement n'est pas correcte
	HEADING.updateMsg_wrong_ref_mesa = function ()
	{
		//Si seulement mesa pion est utilisable en usine et que miroir est coché en utilisateur
		//ou l'inverse, que miroir usine et pion utilisateur coché
		//on affiche le message d'avertissement
		if(		(window[system].MesaCrt[3] == 1 & Radio_ref_mesa0.getValue() == 1) |
			 	(window[system].MesaCrt[3] == 2 & Radio_ref_mesa0.getValue() == 0))
		{
			window.Usermsg_wrong_ref_mesa.setValue(MSG(['warning']));
			window.Usermsg_wrong_ref_mesa.show();
		}
		else
		{
			window.Usermsg_wrong_ref_mesa.hide();
		}

	}
}
else	// si le système n'est pas un Marins, on renvoies les valeurs de CRT et on met la valeur de choix du pion ou du mirroir à 0, qui correspond au pion de centrage
{
	HEADING.construct.local = function ()
	{
		$('#params_finealign_label').html(MSG(['parameters','mesa_title']));
	}

	HEADING.sendConf.local = function ()
	{
		var _params = {};

		_params['MesaCrt'] = window.Input_MesaCrtH.getValue()+","+window.Input_MesaCrtR.getValue()+","+window.Input_MesaCrtP.getValue()
							+ ",0,0";
		return _params;
	};
};